<?php

namespace PixelYourSite;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/** @noinspection PhpIncludeInspection */
require_once PYS_PATH . '/modules/google_analytics/function-helpers.php';

use PixelYourSite\GA\Helpers;
use WC_Product;

require_once PYS_PATH . '/modules/google_analytics/function-collect-data-4v.php';

class GATags extends Settings {

	private static $_instance;
	private $isEnabled;

	private $googleBusinessVertical;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;

	}

	public function __construct() {

		parent::__construct( 'gatags' );

		$this->locateOptions(
			PYS_PATH . '/modules/google_tags/options_fields.json',
			PYS_PATH . '/modules/google_tags/options_defaults.json'
		);

		$this->isEnabled = GA()->enabled() || Ads()->enabled();

		$this->googleBusinessVertical = PYS()->getOption( 'google_retargeting_logic' ) == 'ecomm' ? 'retail' : 'custom';
	}
	public function enabled() {
		return $this->isEnabled;
	}

	public function getUserData() {
		$userData = array();
		$emails = $addresses = $phones = array();

		$user = wp_get_current_user();
		if ( $user != null && $user->ID != 0 ) {
			$user_meta = get_user_meta( $user->ID, '', true );

			$emails[] = $user->user_email;
			if ( !empty( $user_meta[ 'billing_phone' ] ) && !empty( $user_meta[ 'billing_phone' ][ 0 ] ) ) $phones[] = $user_meta[ 'billing_phone' ][ 0 ];

			$first_name = $user->first_name;
			$last_name = $user->last_name;
			$city = !empty( $user_meta[ 'billing_city' ] ) ? $user_meta[ 'billing_city' ][ 0 ] : '';
			$country = !empty( $user_meta[ 'billing_country' ] ) ? $user_meta[ 'billing_country' ][ 0 ] : '';

			if ( $first_name && $last_name && $country && $city ) {

				$address = array(
					'first_name' => $first_name,
					'last_name'  => $last_name,
					'city'       => $city,
					'country'    => $country
				);

				$street = !empty( $user_meta[ 'billing_address_1' ] ) ? $user_meta[ 'billing_address_1' ][ 0 ] : '';
				$region = !empty( $user_meta[ 'billing_state' ] ) ? $user_meta[ 'billing_state' ][ 0 ] : '';
				$zip = !empty( $user_meta[ 'billing_postcode' ] ) ? $user_meta[ 'billing_postcode' ][ 0 ] : '';

				if ( $zip ) $address[ 'postal_code' ] = $zip; // additional
				if ( $street ) $address[ 'street' ] = $street; // additional
				if ( $region ) $address[ 'region' ] = $region; // additional

				$addresses[] = $address;
			}
		}
		if ( isWooCommerceActive() ) {
			$wooOrder = EventsWoo()->getOrder();
			if ( $wooOrder ) {

				$emails[] = $wooOrder->get_billing_email();
				$phones[] = $wooOrder->get_billing_phone();

				$city = $wooOrder->get_billing_city();
				$country = $wooOrder->get_billing_country();
				$first_name = $wooOrder->get_billing_first_name();
				$last_name = $wooOrder->get_billing_last_name();

				if ( $first_name && $last_name && $country && $city ) {
					$address = array(
						'first_name' => $first_name,
						'last_name'  => $last_name,
						'city'       => $city,
						'country'    => $country
					);

					$zip = $wooOrder->get_billing_postcode();
					$street = $wooOrder->get_billing_address_1();

					if ( $zip ) $address[ 'postal_code' ] = $zip; // additional
					if ( $street ) $address[ 'street' ] = $street; // additional

					$addresses[] = $address;
				}
			}
		}
		if ( isEddActive() ) {
			$eddOrderId = EventsEdd()->getEddOrderId();
			if ( $eddOrderId ) {
				$payment = new \EDD_Payment( $eddOrderId );
				if ( $payment ) {
					$meta = $payment->get_meta();
					if ( isset( $meta[ 'user_info' ] ) ) {

						$first_name = $last_name = '';

						if ( isset( $meta[ 'user_info' ][ 'email' ] ) ) {
							$emails[] = $meta[ 'user_info' ][ 'email' ];
						}
						if ( isset( $meta[ 'user_info' ][ 'first_name' ] ) ) {
							$first_name = $meta[ 'user_info' ][ 'first_name' ];
						}
						if ( isset( $meta[ 'user_info' ][ 'last_name' ] ) ) {
							$last_name = $meta[ 'user_info' ][ 'last_name' ];
						}
						if ( isset( $meta[ 'user_info' ][ 'address' ] ) ) {
							$addresses[] = $meta[ 'user_info' ][ 'address' ];
						}

						if ( $first_name && $last_name && !empty( $addresses ) ) {
							$address = array(
								'first_name' => $first_name,
								'last_name'  => $last_name,
								'city'       => $addresses[ 0 ][ 'city' ],
								'country'    => $addresses[ 0 ][ 'country' ]
							);
							$addresses[] = $address;
						}
					}
				}
			}
		}

		if ( GA()->getOption( 'use_multiple_provided_data' ) ) {
			$userData[ 'emails' ] = array_slice( $emails, 0, 3 );
			$userData[ 'phones' ] = array_slice( $phones, 0, 3 );
			$userData[ 'addresses' ] = array_slice( $addresses, 0, 2 );
		} else {
			$userData[ 'emails' ] = array_slice( $emails, 0, 1 );
			$userData[ 'phones' ] = array_slice( $phones, 0, 1 );
			$userData[ 'addresses' ] = array_slice( $addresses, 0, 1 );
		}

		return $userData;
	}
}

/**
 * @return GATags
 */
function GATags() {
	return GATags::instance();
}

GATags();