<?php
namespace PixelYourSite;
class EventsCustom extends EventsFactory {
    private static $_instance;
    public static function instance() {

        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }

        return self::$_instance;

    }

    private function __construct() {
        add_filter("pys_event_factory",[$this,"register"]);
    }

    function register($list) {
        $list[] = $this;
        return $list;
    }

    static function getSlug() {
        return "custom";
    }

    function getEvents(){
        return CustomEventFactory::get( 'active' );
    }

    function getCount()
    {
        if(!$this->isEnabled()) {
            return 0;
        }
        return count($this->getEvents());
    }

    function isEnabled()
    {
        return PYS()->getOption( 'custom_events_enabled' );
    }

    function getOptions()
    {
        return array();
    }

    /**
     * @param CustomEvent $event
     * @return bool
     */
    function isReadyForFire($event)
    {
        switch ($event->getTriggerType()) {
            case 'post_type' : {
                return $event->getPostTypeValue() == get_post_type();
            }
	        case 'number_page_visit' : {
		        $triggers = $event->getNumberPageVisitTriggers();
				if(!empty( $triggers ) && compareURLs( $triggers )){
					$user = get_current_user_id() && get_current_user_id()!==0 ? get_current_user_id() : null;
					$tracker = new PageVisitTracker($user);
					$tracker->update_page_visits($event->getPostId());
					$visitCount = $tracker->get_page_visit_count($event->getPostId());
					if($this->isConditionalNumberVisit($event->getConditionalNumberVisit(), $event->getNumberVisit(), $visitCount)){
						return true;
					}
				}

				return false;
	        }
            case 'page_visit': {
                $triggers = $event->getPageVisitTriggers();
                return !empty( $triggers ) && compareURLs( $triggers );
            }

            case 'url_click': {
                $triggers = $event->getURLClickTriggers();
                $urlFilters = $event->getURLFilters();
                return !empty( $triggers )&& (empty( $urlFilters ) || compareURLs( $urlFilters ));
            }

            case 'css_click': {
                $triggers = $event->getCSSClickTriggers();
                $urlFilters = $event->getURLFilters();
                return !empty( $triggers )&& (empty( $urlFilters ) || compareURLs( $urlFilters ));
            }

            case 'css_mouseover': {
                $triggers = $event->getCSSMouseOverTriggers();
                $urlFilters = $event->getURLFilters();
                return !empty( $triggers )&& (empty( $urlFilters ) || compareURLs( $urlFilters ));
            }

            case 'scroll_pos': {
                $triggers = $event->getScrollPosTriggers();
                $urlFilters = $event->getURLFilters();
                return !empty( $triggers ) && (empty( $urlFilters ) || compareURLs( $urlFilters ));
            }
        }
        if($event->isFormTriggerType())
        {
            $triggers = $event->getFormEventTriggerForms();
            return !empty( $triggers );
        }
        return false;
    }
    /**
     * @param CustomEvent $event
     * @return PYSEvent
     */
    function getEvent($event)
    {
        $payload = array('trigger_type' => $event->getTriggerType());
        $eventObject = null;

        switch ($event->getTriggerType()) {
            case 'post_type' :
            case 'page_visit':
	        case 'number_page_visit':{
                $singleEvent = new SingleEvent('custom_event',EventTypes::$STATIC,self::getSlug());
                $singleEvent->args = $event;
                $eventObject = $singleEvent;
            } break;

            case 'url_click': {
                foreach ($event->getURLClickTriggers() as $trigger)
                    $payload['trigger_value'][] = $trigger;
                $singleEvent = new SingleEvent('custom_event',EventTypes::$TRIGGER,self::getSlug());
                $singleEvent->addPayload($payload);
                $singleEvent->args = $event;
                $eventObject = $singleEvent;
            } break;
            case 'css_click': {
                foreach ($event->getCSSClickTriggers() as $trigger)
                    $payload['trigger_value'][] = $trigger['value'];
                $singleEvent = new SingleEvent('custom_event',EventTypes::$TRIGGER,self::getSlug());
                $singleEvent->args = $event;
                $singleEvent->addPayload($payload);
                $eventObject = $singleEvent;
            }break;
            case 'css_mouseover': {
                foreach ($event->getCSSMouseOverTriggers() as $trigger)
                    $payload['trigger_value'][] = $trigger['value'];
                $singleEvent = new SingleEvent('custom_event',EventTypes::$TRIGGER,self::getSlug());
                $singleEvent->args = $event;
                $singleEvent->addPayload($payload);
                $eventObject = $singleEvent;
            } break;
            case 'scroll_pos': {
                foreach ($event->getScrollPosTriggers() as $trigger)
                    $payload['trigger_value'][] = $trigger['value'];
                $singleEvent = new SingleEvent('custom_event',EventTypes::$TRIGGER,self::getSlug());
                $singleEvent->args = $event;
                $singleEvent->addPayload($payload);
                $eventObject = $singleEvent;
            } break;
        }
        if($event->isFormTriggerType())
        {
            $triggers = $event->getFormEventTriggerForms();
            $payload['trigger_type_event'] = 'form';
            if($event->__get('disabled_form_action'))
            {
                $payload['disabled_form_action'] = $event->__get('disabled_form_action');
            }
            foreach ($triggers as $trigger)
                $payload['trigger_value'][] = $trigger;
            $singleEvent = new SingleEvent('custom_event',EventTypes::$TRIGGER,self::getSlug());
            $singleEvent->args = $event;
            $singleEvent->addPayload($payload);
            $eventObject = $singleEvent;
        }

	    $eventObject->addPayload(["custom_event_post_id" => $event->__get('post_id')]);

        if(isset($eventObject) && $event->hasTimeWindow()) {
            $eventObject->addPayload(["hasTimeWindow" => $event->hasTimeWindow()]);
            $eventObject->addPayload(["timeWindow" => $event->getTimeWindow()]);
        }

        if($event->getDelay() > 0) {
            $eventObject->addPayload(["delay" => $event->getDelay()]);
        }

        return $eventObject;
    }

	function isConditionalNumberVisit($operator, $visitCount, $currentVisits) {
		switch ($operator) {
			case 'equal':
				return $currentVisits == $visitCount;
			case 'equal_or_larger':
				return $currentVisits >= $visitCount;
			case 'equal_or_less':
				return $currentVisits <= $visitCount;
			case 'larger':
				return $currentVisits > $visitCount;
			case 'less':
				return $currentVisits < $visitCount;
			default:
				// Handle unexpected operator
				return false;
		}
	}
}
/**
 * @return EventsCustom
 */
function EventsCustom() {
    return EventsCustom::instance();
}

EventsCustom();