<?php

function fifu_woo_zoom() {
    return fifu_is_on('fifu_wc_zoom') ? 'inline' : 'none';
}

function fifu_woo_lbox() {
    return fifu_is_on('fifu_wc_lbox');
}

function fifu_woo_theme() {
    return file_exists(get_template_directory() . '/woocommerce');
}

# https://docs.woocommerce.com/document/image-sizes-theme-developers/

function fifu_woo_get_image_size() {
    if (class_exists('WooCommerce')) {
        if (is_shop())
            return wc_get_image_size('woocommerce_get_image_size_woocommerce_thumbnail');
        if (is_product())
            return wc_get_image_size('woocommerce_get_image_size_woocommerce_single');
    }
}

define('FIFU_FIX_IMAGES_WITHOUT_DIMENSIONS',
        "function fix_images_without_dimensions() {
        jQuery('img[data-large_image_height=0]').each(function () {
            if (jQuery(this)[0].naturalWidth <= 2)
                return;

            jQuery(this)
                .attr('data-large_image_width', jQuery(this)[0].naturalWidth)
                .attr('data-large_image_height', jQuery(this)[0].naturalHeight);

            jQuery('div.flex-viewport').css('height', jQuery(this)[0].clientHeight);
        });
    }
    fix_images_without_dimensions();"
);

function fifu_woocommerce_gallery_image_html_attachment_image_params($params, $attachment_id, $image_size, $main_image) {
    // fix zoom
    if ($params['data-large_image_width'] == 0) {
        $params['data-large_image_width'] = 1920;
        $params['data-large_image_height'] = 0;
    }

    // fix lightbox
    if (is_product())
        $params['onload'] = FIFU_FIX_IMAGES_WITHOUT_DIMENSIONS;

    return $params;
}

add_filter('woocommerce_gallery_image_html_attachment_image_params', 'fifu_woocommerce_gallery_image_html_attachment_image_params', 10, 4);

function fifu_woo_template_override($template, $slug) {
    global $post;

    $product_page = array('single-product/product-image.php');

    if (fifu_is_on('fifu_gallery') && $post && class_exists('WooCommerce') && is_product()) {
        if (in_array($slug, $product_page)) {
            // if (fifu_is_yith_woocommerce_badges_management_active())
            echo apply_filters('woocommerce_single_product_image_thumbnail_html', '', $post->ID);
            return FIFU_INCLUDES_DIR . '/template.php';
        }
    }
    return $template;
}

add_filter('wc_get_template', 'fifu_woo_template_override', 99, 2);

function fifu_in_gallery($att_id) {
    $att_post = get_post($att_id);
    $post_parent = get_post($att_post->post_parent);
    if (!isset($post_parent->ID))
        return false;
    $gallery_ids = get_post_meta($post_parent->ID, '_product_image_gallery', true);
    if ($gallery_ids)
        $gallery_ids = explode(',', $gallery_ids);
    if (is_array($gallery_ids))
        return in_array($att_id, $gallery_ids);
    return false;
}

add_action('woocommerce_product_duplicate', 'fifu_woocommerce_product_duplicate', 10, 1);

function fifu_woocommerce_product_duplicate($array) {
    if (!$array || !$array->get_meta_data())
        return;

    $post_id = $array->get_id();
    foreach ($array->get_meta_data() as $meta_data) {
        $data = $meta_data->get_data();
        if (in_array($data['key'], array('fifu_image_url', 'fifu_video_url', 'fifu_slider_image_url_0'))) {
            delete_post_meta($post_id, '_thumbnail_id');
        } else if (
                (strpos($data['key'], 'fifu_image_url_') !== false) ||
                (strpos($data['key'], 'fifu_video_url_') !== false) ||
                (strpos($data['key'], 'fifu_slider_image_url_') !== false)) {
            delete_post_meta($post_id, '_product_image_gallery');
        }
    }
}

function fifu_gallery_get_html($post_id, $original_class, $gallery_class, $gallery_css) {
    $ratio = get_post_meta($post_id, 'fifu_slider_ratio', true);
    $ratio = $ratio ? 'fifu-ratio="' . $ratio . '"' : '';

    $class = fifu_is_lazy() ? "fifu lazyload" : "fifu";
    $class .= ' ' . $original_class;

    $attribute_map = array();
    $url_map = array();
    $srcset_map = array();

    // variable products
    $attributes = fifu_db_get_variation_attributes($post_id);
    if ($attributes) {
        foreach ($attributes as $attribute) {
            if (!isset($attribute_map[$attribute->meta_key])) {
                $attribute_map[$attribute->meta_key] = array();
            }
            if (!isset($attribute_map[$attribute->meta_key][$attribute->meta_value])) {
                $attribute_map[$attribute->meta_key][$attribute->meta_value] = array();
            }
            array_push($attribute_map[$attribute->meta_key][$attribute->meta_value], $attribute->post_id);

            if (!isset($url_map[$attribute->post_id])) {
                $aux = fifu_db_get_featured_and_gallery_urls($attribute->post_id);
                if ($aux) {
                    $tmp = explode('|', $aux[0]->urls);
                    for ($i = 0; $i < sizeof($tmp); $i++) {
                        $tmp[$i] = fifu_get_cdn_url($tmp[$i]);
                        $url = $tmp[$i];
                        if (is_from_jetpack($url) && fifu_is_lazy())
                            $srcset_map[$url] = fifu_jetpack_get_set($url, true);
                    }
                    $url_map[$attribute->post_id] = $tmp;
                }
            }
        }
    }

    $gallery_css = $gallery_css ? 'style="' . $gallery_css . '"' : '';

    $html = sprintf('<div class="fifu-slider %s" id="fifu-slider-%s" %s %s>', $gallery_class, $post_id, $ratio, $gallery_css);
    if (fifu_is_on('fifu_slider_counter'))
        $html = $html . '<div style="font-size:12px; padding:2px 5px 2px 5px; background:rgba(0, 0, 0, 0.1); z-index:50; position:absolute; color:white" id="counter-slider"></div>';
    $html = $html . '<ul id="image-gallery" class="gallery list-unstyled cS-hidden fifu-product-gallery">';

    $att_id = get_post_meta($post_id, '_thumbnail_id', true);
    if ($att_id) {
        $url = get_the_guid($att_id);
    }

    if (!$att_id || !$url)
        return;

    $url = fifu_get_cdn_url($url);
    if (is_from_jetpack($url) && fifu_is_lazy())
        $srcset_map[$url] = fifu_jetpack_get_set($url, true);
    $urls = array($url);

    $att_ids = get_post_meta($post_id, '_product_image_gallery', true);
    if ($att_ids) {
        $att_ids = explode(',', $att_ids);
        foreach ($att_ids as $att_id) {
            $url = get_the_guid($att_id);
            $url = fifu_get_cdn_url($url);
            if (is_from_jetpack($url) && fifu_is_lazy())
                $srcset_map[$url] = fifu_jetpack_get_set($url, true);
            array_push($urls, $url);
        }
    }

    // urls of parent product
    $url_map[$post_id] = $urls;

    // js
    wp_enqueue_script('fifu-variable-js', plugins_url('/html/js/variable.js', __FILE__), array('jquery'), fifu_version_number());
    wp_localize_script('fifu-variable-js', 'fifuVariableVars', [
        'attribute_map' => $attribute_map,
        'url_map' => $url_map,
        'srcset_map' => $srcset_map,
        'post_id' => $post_id,
        'fifu_lazy' => fifu_is_on('fifu_lazy'),
        'fifu_video' => fifu_is_on('fifu_video'),
    ]);

    $i = -1;
    $i_video = null;
    foreach ($urls as $url) {
        $i++;
        $error_url = get_option('fifu_error_url');

        // get video URL
        if (fifu_is_video($url)) {
            if (is_null($i_video)) {
                $video_url = get_post_meta($post_id, 'fifu_video_url', true);
                if (!$video_url) {
                    $video_url = get_post_meta($post_id, 'fifu_video_url_0', true);
                    $i_video = 1;
                } else
                    $i_video = 0;
            } else
                $video_url = get_post_meta($post_id, 'fifu_video_url_' . $i_video++, true);
        }

        if ($url) {
            if (is_from_flickr($url)) {
                $html = $html . sprintf(
                                '<li data-thumb="%s" data-src="%s" data-srcset="%s"><img data-src="%s" data-srcset="%s" data-sizes="auto" class="%s" onerror="%s"/></li>',
                                $url,
                                FIFU_PLACEHOLDER,
                                fifu_flickr_get_set($url),
                                preg_replace('/([_][a-z]){0,1}.jpg/', '_t.jpg', $url),
                                fifu_flickr_get_set($url),
                                $original_class,
                                "jQuery(this).hide();"
                );
                continue;
            } else if (fifu_is_from_speedup($url)) {
                if (fifu_is_video($url)) {
                    $html = $html . sprintf(
                                    '<li data-thumb="%s" data-src="%s" data-srcset="%s" data-poster="%s"><img data-src="%s" data-srcset="%s" data-sizes="auto" class="%s" onerror="%s"/></li>',
                                    fifu_speedup_get_signed_url($url, 128, 128, null, null, false),
                                    $video_url,
                                    fifu_speedup_get_set($url),
                                    $url,
                                    fifu_speedup_get_signed_url($url, 128, 128, null, null, false),
                                    fifu_speedup_get_set($url),
                                    $original_class,
                                    "jQuery(this).hide();"
                    );
                    continue;
                }

                $html = $html . sprintf(
                                '<li data-thumb="%s" data-src="%s" data-srcset="%s"><img data-src="%s" data-srcset="%s" data-sizes="auto" class="%s" onerror="%s"/></li>',
                                fifu_speedup_get_signed_url($url, 128, 128, null, null, false),
                                FIFU_PLACEHOLDER,
                                fifu_speedup_get_set($url),
                                fifu_speedup_get_signed_url($url, 128, 128, null, null, false),
                                fifu_speedup_get_set($url),
                                $original_class,
                                "jQuery(this).hide();"
                );
                continue;
            } else if (is_from_jetpack($url) && fifu_is_lazy()) {
                $html = $html . sprintf(
                                '<li data-thumb="%s" data-src="%s" data-srcset="%s"><img data-src="%s" data-srcset="%s" data-sizes="auto" class="%s" onerror="%s"/></li>',
                                fifu_resize_jetpack_image_size(175, $url),
                                FIFU_PLACEHOLDER,
                                fifu_jetpack_get_set($url, true),
                                fifu_resize_jetpack_image_size(175, $url),
                                fifu_jetpack_get_set($url, true),
                                $original_class,
                                "jQuery(this).hide();"
                );
                continue;
            }

            if (fifu_is_video($url)) {
                $html = $html . sprintf(
                                '<li data-thumb="%s" data-src="%s" data-poster="%s"><img %s class="img-responsive%s" onerror="%s"/></li>',
                                $url,
                                $video_url,
                                $url,
                                fifu_lazy_url($url),
                                $class ? ' ' . $class : '',
                                $error_url ? sprintf("this.src='%s'", $error_url) : ""
                );
            } else {
                $html = $html . sprintf(
                                '<li data-thumb="%s" data-src="%s"><img %s class="%s" onerror="%s"/></li>',
                                $url,
                                $url,
                                fifu_lazy_url($url),
                                $class,
                                $error_url ? sprintf("this.src='%s'", $error_url) : ""
                );
            }
        }
    }
    // add status
    $html = str_replace('<img ', '<img fifu-replaced="1" ', $html);
    return $html . '</ul></div>';
}

function fifu_get_cdn_url($url) {
    if (fifu_is_on('fifu_photon') && !fifu_is_video_thumb($url))
        return fifu_jetpack_photon_url($url, null);
    return $url;
}

