<?php

/*
 * thumbnail_small 100 x 75
 * thumbnail_medium 200 x 150
 * thumbnail_large 640 x 476
 */

function fifu_vimeo_img($url, $size) {
    $contents = @file_get_contents("https://vimeo.com/api/v2/video/" . fifu_vimeo_id($url) . ".php");
    $img = $contents ? unserialize($contents) : null;
    return ($img != null ? $img[0][$size] : fifu_vimeo_private_thumb($url)) . '?' . fifu_vimeo_id($url);
}

function fifu_vimeo_private_thumb($url) {
    $curl = curl_init('https://vimeo.com/api/oembed.json?url=' . $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_REFERER, fifu_get_domain());
    $data = curl_exec($curl);
    curl_close($curl);

    $arr = json_decode($data, true);

    if (!$arr || !array_key_exists('thumbnail_url', $arr))
        return null;

    $thumb_url = $arr['thumbnail_url'];
    // change size
    $thumb_url = preg_replace("/_[0-9]+x[0-9]+/", "_640", $thumb_url);
    return $thumb_url ? $thumb_url : null;
}

function fifu_vimeo_id($url) {
    preg_match("/(https?:\/\/)?(www\.)?(player\.)?vimeo\.com\/([a-z]*\/)*([0-9]{6,11})[?]?.*/", $url, $matches);
    return sizeof($matches) > 4 ? $matches[5] : null;
}

function fifu_vimeo_src($url) {
    return 'https://player.vimeo.com/video/' . fifu_vimeo_id($url);
}

function fifu_is_vimeo_video($url) {
    return strpos($url, 'vimeo') !== false;
}

function fifu_vimeo_social_url($id) {
    return 'https://player.vimeo.com/video/' . $id . '?autoplay=1';
}

function fifu_vimeo_social_img($url) {
    return fifu_vimeo_img($url, 'thumbnail_large');
}

function fifu_is_vimeo_thumb($src) {
    return strpos($src, 'i.vimeocdn.com') !== false;
}

/*
 * default 120 x 90
 * mqdefault 320 x 180
 * hqdefault 480 x 360
 * sddefault 640 x 480
 * maxresdefault
 */

function fifu_youtube_img($url, $size) {
    return 'https://img.youtube.com/vi/' . fifu_video_id($url) . '/' . $size . '.jpg' . fifu_youtube_parameter($url);
}

function fifu_youtube_id($url) {
    preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user|shorts)\/))([^\?&\"'>]+)/", $url, $matches);
    return sizeof($matches) > 0 ? $matches[1] : null;
}

function fifu_youtube_id_from_thumb($url) {
    return explode('/', $url)[4];
}

function fifu_youtube_src($url) {
    return 'https://www.youtube.com/embed/' . fifu_video_id($url);
}

function fifu_is_youtube_video($url) {
    return strpos($url, 'youtu') !== false;
}

function fifu_youtube_social_url($id) {
    return 'https://www.youtube.com/v/' . $id . '?version=3&amp;autohide=1';
}

function fifu_youtube_social_img($url) {
    return 'https://i.ytimg.com/vi/' . fifu_youtube_id($url) . '/hqdefault.jpg';
}

function fifu_youtube_parameter($url) {
    if (strpos($url, '?') === false)
        return null;
    $qp = parse_url($url, PHP_URL_QUERY);
    $qp = preg_replace('/v=[^&]+[&]*/', '', $qp);
    return $qp ? '?' . $qp : '';
}

function fifu_is_youtube_thumb($src) {
    return strpos($src, 'img.youtube.com') !== false;
}

/*
 * cloudinary
 */

function fifu_cloudinary_src($url) {
    return $url;
}

function fifu_is_cloudinary_video($url) {
    return strpos($url, 'cloudinary.com') !== false && strpos($url, '/video/') !== false;
}

function fifu_cloudinary_img($url) {
    return str_replace('mp4', 'jpg', $url);
}

function fifu_cloudinary_social_img($url) {
    return fifu_cloudinary_img($url);
}

function fifu_is_cloudinary_thumb($src) {
    return strpos($src, 'res.cloudinary.com') !== false && strpos($src, '/video/') !== false;
}

/*
 * tumblr
 */

function fifu_tumblr_src($url) {
    return $url;
}

function fifu_is_tumblr_video($url) {
    return strpos($url, 'tumblr.com') !== false;
}

function fifu_tumblr_img($url) {
    $tmp = str_replace('https://vt.media.tumblr.com', 'https://78.media.tumblr.com', $url);
    return str_replace('.mp4', '_smart1.jpg', $tmp);
}

function fifu_tumblr_social_img($url) {
    return fifu_tumblr_img($url);
}

function fifu_is_tumblr_thumb($src) {
    return strpos($src, 'tumblr.com') !== false;
}

/*
 * local
 */

function fifu_local_src($url) {
    return $url;
}

function fifu_is_local_video($url) {
    return strpos($url, '/wp-content/uploads/') !== false && strpos($url, '.mp4') !== false;
}

function fifu_local_img($url) {
    return str_replace('.mp4', '-fifu-mp4.webp', $url);
}

function fifu_local_social_img($url) {
    return fifu_local_img($url);
}

function fifu_is_local_thumb($src) {
    return strpos($src, '/wp-content/uploads/') !== false && strpos($src, '-fifu-') !== false;
}

/*
 * imgur
 */

function fifu_imgur_src($url) {
    return $url;
}

function fifu_is_imgur_video($url) {
    return strpos($url, 'imgur.com') !== false && strpos($url, 'mp4') !== false;
}

function fifu_imgur_img($url) {
    return str_replace('mp4', 'jpg?video', $url);
}

function fifu_imgur_social_img($url) {
    return fifu_imgur_img($url);
}

function fifu_is_imgur_thumb($src) {
    return strpos($src, 'imgur.com') !== false && strpos($src, '?video') !== false;
}

/*
 * publitio
 */

function fifu_publitio_src($url) {
    return $url;
}

function fifu_is_publitio_video($url) {
    return strpos($url, 'publit.io') !== false;
}

function fifu_publitio_img($url) {
    return str_replace('mp4', 'jpg', $url);
}

function fifu_publitio_social_img($url) {
    return fifu_publitio_img($url);
}

function fifu_is_publitio_thumb($src) {
    return strpos($src, 'publit.io') !== false;
}

/* gag */

function fifu_gag_src($url) {
    return $url;
}

function fifu_is_gag_video($url) {
    return strpos($url, '9cache.com') !== false;
}

function fifu_gag_img($url) {
    return explode('_', $url)[0] . '_460c_offset0.jpg';
}

function fifu_gag_social_img($url) {
    return fifu_gag_img($url);
}

function fifu_is_gag_thumb($src) {
    return strpos($src, '9cache.com') !== false;
}

/* wordpress.com */

function fifu_wpcom_src($url) {
    return $url;
}

function fifu_is_wpcom_video($url) {
    return strpos($url, 'videos.files.wordpress.com') !== false;
}

function fifu_wpcom_img($url) {
    return str_replace('mp4', 'original.jpg', $url);
}

function fifu_wpcom_social_img($url) {
    return fifu_wpcom_img($url);
}

function fifu_is_wpcom_thumb($src) {
    return strpos($src, 'videos.files.wordpress.com') !== false;
}

/* jwplayer */

function fifu_jwplayer_id($url) {
    return explode('.', explode('/', $url)[4])[0];
}

function fifu_jwplayer_player_id($url) {
    return explode('-', fifu_jwplayer_id($url))[1];
}

function fifu_jwplayer_src($url) {
    return 'https://content.jwplatform.com/players/' . fifu_video_id($url) . '.html';
}

function fifu_is_jwplayer_video($url) {
    return strpos($url, 'jwplayer.com') !== false;
}

function fifu_jwplayer_img($url, $size) {
    $left_id = explode('-', fifu_video_id($url))[0];
    return 'https://content.jwplatform.com/thumbs/' . $left_id . '-' . $size . '.jpg';
}

function fifu_jwplayer_social_img($url) {
    return fifu_jwplayer_img($url, 1280);
}

function fifu_is_jwplayer_thumb($src) {
    return strpos($src, 'jwplatform.com') !== false;
}

function fifu_jwplayer_social_url($id) {
    return 'https://cdn.jwplayer.com/players/' . $id . '.html';
}

/* sprout */

function fifu_sprout_oembed($url) {
    $curl = curl_init('https://sproutvideo.com/oembed.json?url=' . $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_REFERER, fifu_get_domain());
    $data = curl_exec($curl);
    curl_close($curl);

    return json_decode($data, true);
}

function fifu_sprout_id($url) {
    
}

function fifu_is_sprout_video($url) {
    return strpos($url, 'vids.io') !== false;
}

function fifu_sprout_src($url) {
    $arr = fifu_sprout_oembed(fifu_sprout_oembed_url($url));
    return explode("'", $arr['html'])[3];
}

function fifu_video_src_by_img($url) {
    $aux = explode('/', $url);
    $video_id = $aux[3];
    $security_token = $aux[4];
    return 'https://videos.sproutvideo.com/embed/' . $video_id . '/' . $security_token;
}

function fifu_sprout_img($url) {
    $src = fifu_sprout_src($url);
    $aux = explode('/', $src);
    $video_id = $aux[4];
    $security_token = $aux[5];
    return 'https://cdn-thumbnails.sproutvideo.com/' . $video_id . '/' . $security_token . '/1/';
}

function fifu_sprout_social_img($url) {
    return fifu_sprout_img($url);
}

function fifu_is_sprout_thumb($src) {
    return strpos($src, 'cdn-thumbnails.sproutvideo.com') !== false;
}

function fifu_sprout_oembed_url($video_url) {
    $matches = array();
    preg_match('/^http.*\//', $video_url, $matches);
    return $matches[0];
}

/* suvideo */

function fifu_suvideo_id($url) {
    $video_url = fifu_suvideo_video_url_only($url);
    return fifu_video_id($video_url);
}

function fifu_suvideo_src($url) {
    $video_url = fifu_suvideo_video_url_only($url);
    return fifu_video_src($video_url);
}

function fifu_is_suvideo_video($url) {
    return strpos($url, 'fifu-thumb=') !== false;
}

function fifu_suvideo_img($url) {
    $video_url = fifu_suvideo_video_url_only($url);
    $image_url = fifu_video_img_small($video_url);
    return fifu_suvideo_thumb_url_only($url) . '?video-thumb=' . fifu_remove_query_strings($image_url);
}

function fifu_suvideo_social_img($url) {
    return fifu_suvideo_img($url);
}

function fifu_is_suvideo_thumb($src) {
    return strpos($src, 'cdn.fifu.app') !== false && strpos($src, 'video-thumb') !== false;
}

function fifu_suvideo_social_url($id) {
    return fifu_video_social_url($id);
}

function fifu_suvideo_video_url_only($url) {
    return preg_replace("/.fifu-thumb=.*/", "", $url);
}

function fifu_suvideo_thumb_url_only($url) {
    return preg_replace("/.*fifu-thumb=/", "", $url);
}

/*
 * size
 */

function fifu_is_video($url) {
    return fifu_is_youtube_video($url) || fifu_is_vimeo_video($url) || fifu_is_cloudinary_video($url) || fifu_is_tumblr_video($url) || fifu_is_local_video($url) || fifu_is_imgur_video($url) || fifu_is_publitio_video($url) || fifu_is_gag_video($url) || fifu_is_wpcom_video($url) || fifu_is_jwplayer_video($url) || fifu_is_sprout_video($url);
}

function fifu_video_id($url) {
    if (fifu_is_youtube_video($url))
        return fifu_youtube_id($url);
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_id($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_id($url);
    return null;
}

function fifu_video_img($url, $size) {
    if (fifu_is_suvideo_video($url))
        return fifu_suvideo_img($url);
    if (fifu_is_youtube_video($url))
        return fifu_youtube_img($url, $size);
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_img($url, $size);
    if (fifu_is_cloudinary_video($url))
        return fifu_cloudinary_img($url);
    if (fifu_is_tumblr_video($url))
        return fifu_tumblr_img($url);
    if (fifu_is_local_video($url))
        return fifu_local_img($url);
    if (fifu_is_imgur_video($url))
        return fifu_imgur_img($url);
    if (fifu_is_publitio_video($url))
        return fifu_publitio_img($url);
    if (fifu_is_gag_video($url))
        return fifu_gag_img($url);
    if (fifu_is_wpcom_video($url))
        return fifu_wpcom_img($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_img($url, $size);
    if (fifu_is_sprout_video($url))
        return fifu_sprout_img($url);
    return null;
}

function fifu_video_img_small($url) {
    if (fifu_is_suvideo_video($url))
        return fifu_suvideo_img($url);
    if (fifu_is_youtube_video($url))
        return fifu_youtube_img($url, 'default');
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_img($url, 'thumbnail_small');
    if (fifu_is_cloudinary_video($url))
        return fifu_cloudinary_img($url);
    if (fifu_is_tumblr_video($url))
        return fifu_tumblr_img($url);
    if (fifu_is_local_video($url))
        return fifu_local_img($url);
    if (fifu_is_imgur_video($url))
        return fifu_imgur_img($url);
    if (fifu_is_publitio_video($url))
        return fifu_publitio_img($url);
    if (fifu_is_gag_video($url))
        return fifu_gag_img($url);
    if (fifu_is_wpcom_video($url))
        return fifu_wpcom_img($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_img($url, 320);
    if (fifu_is_sprout_video($url))
        return fifu_sprout_img($url);
    return null;
}

function fifu_video_img_large($url, $post_id, $is_category) {
    if (fifu_is_suvideo_video($url))
        return fifu_suvideo_img($url);
    if (fifu_is_youtube_video($url)) {
        if ($post_id) {
            $att_id = fifu_db_get_att_id($post_id, $url, false);
            $att_id = $att_id ? $att_id : fifu_db_get_att_id($post_id, fifu_youtube_img($url, 'maxresdefault'), false);
            $att_id = $att_id ? $att_id : fifu_db_get_att_id($post_id, fifu_youtube_img($url, 'mqdefault'), false);

            $maxres = get_post_meta($att_id, 'fifu_yt_res', true);
            if ($maxres)
                return fifu_youtube_img($url, $maxres);
        }
        return fifu_youtube_img($url, 'maxresdefault');
    }
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_img($url, 'thumbnail_large');
    if (fifu_is_cloudinary_video($url))
        return fifu_cloudinary_img($url);
    if (fifu_is_tumblr_video($url))
        return fifu_tumblr_img($url);
    if (fifu_is_local_video($url))
        return fifu_local_img($url);
    if (fifu_is_imgur_video($url))
        return fifu_imgur_img($url);
    if (fifu_is_publitio_video($url))
        return fifu_publitio_img($url);
    if (fifu_is_gag_video($url))
        return fifu_gag_img($url);
    if (fifu_is_wpcom_video($url))
        return fifu_wpcom_img($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_img($url, 1280);
    if (fifu_is_sprout_video($url)) {
        if ($post_id) {
            $att_id = get_post_thumbnail_id($post_id);
            $att_post = get_post($att_id);
            $guid = $att_post->guid;
            if ($guid)
                return fifu_video_src_by_img($guid);
        }
        return fifu_sprout_img($url);
    }
    return null;
}

function fifu_video_src($url) {
    if (fifu_is_suvideo_video($url))
        return fifu_suvideo_src($url);
    if (fifu_is_youtube_video($url))
        return fifu_youtube_src($url);
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_src($url);
    if (fifu_is_cloudinary_video($url))
        return fifu_cloudinary_src($url);
    if (fifu_is_tumblr_video($url))
        return fifu_tumblr_src($url);
    if (fifu_is_local_video($url))
        return fifu_local_src($url);
    if (fifu_is_imgur_video($url))
        return fifu_imgur_src($url);
    if (fifu_is_publitio_video($url))
        return fifu_publitio_src($url);
    if (fifu_is_gag_video($url))
        return fifu_gag_src($url);
    if (fifu_is_wpcom_video($url))
        return fifu_wpcom_src($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_src($url);
    if (fifu_is_sprout_video($url))
        return fifu_sprout_src($url);
    return null;
}

function fifu_video_social_url($id) {
    if (fifu_is_youtube_video($id))
        return fifu_youtube_social_url($id);
    if (fifu_is_vimeo_video($id))
        return fifu_vimeo_social_url($id);
    if (fifu_is_jwplayer_video($id))
        return fifu_jwplayer_social_url($id);
    return null;
}

function fifu_video_social_img($url) {
    if (fifu_is_suvideo_video($url))
        return fifu_suvideo_img($url);
    if (fifu_is_youtube_video($url))
        return fifu_youtube_social_img($url);
    if (fifu_is_vimeo_video($url))
        return fifu_vimeo_social_img($url);
    if (fifu_is_cloudinary_video($url))
        return fifu_cloudinary_img($url);
    if (fifu_is_tumblr_video($url))
        return fifu_tumblr_img($url);
    if (fifu_is_local_video($url))
        return fifu_local_img($url);
    if (fifu_is_imgur_video($url))
        return fifu_imgur_img($url);
    if (fifu_is_publitio_video($url))
        return fifu_publitio_img($url);
    if (fifu_is_gag_video($url))
        return fifu_gag_img($url);
    if (fifu_is_wpcom_video($url))
        return fifu_wpcom_img($url);
    if (fifu_is_jwplayer_video($url))
        return fifu_jwplayer_social_img($url);
    if (fifu_is_sprout_video($url))
        return fifu_sprout_img($url);
    return null;
}

function fifu_is_video_thumb($url) {
    return
            fifu_is_suvideo_thumb($url) ||
            fifu_is_youtube_thumb($url) ||
            fifu_is_vimeo_thumb($url) ||
            fifu_is_cloudinary_thumb($url) ||
            fifu_is_tumblr_thumb($url) ||
            fifu_is_local_thumb($url) ||
            fifu_is_imgur_thumb($url) ||
            fifu_is_publitio_thumb($url) ||
            fifu_is_gag_thumb($url) ||
            fifu_is_wpcom_thumb($url) ||
            fifu_is_jwplayer_thumb($url) ||
            fifu_is_sprout_thumb($url);
}

/*
 * auto play
 */

function fifu_mouse_youtube_enabled() {
    return fifu_is_on('fifu_mouse_youtube');
}

function fifu_mouse_vimeo_enabled() {
    return fifu_is_on('fifu_mouse_vimeo');
}

/*
 * parameters
 */

function fifu_autoplay_enabled() {
    return fifu_is_on('fifu_autoplay');
}

function fifu_video_related_enabled() {
    return fifu_is_on('fifu_video_related');
}

function fifu_video_mute_enabled() {
    return fifu_is_on('fifu_video_mute');
}

function fifu_video_background_enabled() {
    return fifu_is_on('fifu_video_background');
}

function fifu_loop_enabled() {
    return fifu_is_on('fifu_loop');
}

/*
 * thumbnail
 */

function fifu_video_thumb_enabled_home() {
    return fifu_is_on('fifu_video_thumb') && (is_home() || (class_exists('WooCommerce') && is_shop()) || is_archive() || is_search());
}

function fifu_video_thumb_enabled_page() {
    return fifu_is_on('fifu_video_thumb_page') && is_page();
}

function fifu_video_thumb_enabled_post() {
    return fifu_is_on('fifu_video_thumb_post') && is_singular('post');
}

function fifu_video_thumb_enabled_cpt() {
    return fifu_is_on('fifu_video_thumb_cpt') && fifu_is_cpt();
}

function fifu_video_thumb_enabled() {
    return fifu_is_on('fifu_video_thumb') || fifu_is_on('fifu_video_thumb_page') || fifu_is_on('fifu_video_thumb_post');
}

/*
 * ajax
 */

function fifu_should_wait_ajax() {
    return (fifu_is_yith_woocommerce_wishlist_active() && fifu_is_yith_woocommerce_wishlist_ajax_enabled());
}

/* dimensions */

function fifu_updade_youtube_dimensions($att_id, $url) {
    $metadata = wp_get_attachment_metadata($att_id);
    if ($metadata && $metadata['width'] == 120 && $metadata['height'] == 90) {
        // resolution
        update_post_meta($att_id, 'fifu_yt_res', 'mqdefault');

        // metadata
        update_post_meta($att_id, '_wp_attached_file', $url);

        // guid
        global $wpdb;
        $wpdb->update($wpdb->posts, ['guid' => $url], ['ID' => $att_id]);

        // dimension
        $metadata['width'] = 320;
        $metadata['height'] = 180;
        wp_update_attachment_metadata($att_id, $metadata);
    } else
        update_post_meta($att_id, 'fifu_yt_res', 'maxresdefault');
}

