var fifu_slider;

(function ($) {
    $(document).ready(function () {
        fifu_slider = fifu_load_slider();
    });
})(jQuery);

function fifu_load_slider() {
    return jQuery(".gallery.list-unstyled:not(.already-loaded)").lightSlider({
        gallery: true,
        mode: 'fade',
        item: 1,
        thumbItem: 5,
        slideMargin: 0,
        adaptiveHeight: fifuSliderVars.fifu_is_product && fifuSliderVars.fifu_adaptive_height ? true : false,
        speed: fifuSliderVars.fifu_slider_speed,
        auto: fifuSliderVars.fifu_slider_auto,
        loop: true,
        freeMove: true,
        enableDrag: false,
        enableTouch: true,
        pager: fifuSliderVars.fifu_slider_thumb, // true can cause lazy load problems
        vertical: false,
        verticalHeight: 300,
        vThumbWidth: 100,
        slideEndAnimation: false,
        pause: fifuSliderVars.fifu_slider_pause,
        controls: fifuSliderVars.fifu_slider_ctrl,
        pauseOnHover: fifuSliderVars.fifu_slider_stop,
        prevHtml: '<img class="fifu-arrow" src="' + fifuSliderVars.fifu_slider_left + '"/>',
        nextHtml: '<img class="fifu-arrow" src="' + fifuSliderVars.fifu_slider_right + '"/>',
        onSliderLoad: function (el) {
            // el == this == ul
            jQuery(el).removeClass("cS-hidden");

            // avoid duplicated slider elements after ajax calls
            jQuery(el).addClass("already-loaded");

            // use 1st image instead of slider
            if (el[0].clientWidth < 175 || (el.find('img')[0].clientWidth > 0 && el.find('img')[0].clientWidth < 175)) {
                imgs = el.find('img');
                firstImage = imgs[0];
                el.parents('div.fifu-slider').replaceWith(firstImage);
                jQuery(firstImage).css('height', '');
                jQuery(firstImage).css('width', '');
                if (fifuSliderVars.fifu_lazy)
                    jQuery(firstImage).addClass('lazyload');
                return false;
            }

            // zoom
            // if (fifuSliderVars.fifu_is_product && !fifuSliderVars.fifu_is_mobile) {
            //     jQuery(el).find('li').each(function (index) {
            //         if (jQuery(this).attr('data-srcset')) {
            //             urls = jQuery(this).attr('data-srcset').split(', ');
            //             last = urls[urls.length - 1].split(' ')[0];
            //             if (!last.includes('video-thumb')) {
            //                 jQuery(this).zoom({url: last});
            //             }
            //         }
            //     });
            // }

            // add slider gallery
            setTimeout(() => {
                if (fifuSliderVars.fifu_slider_gallery) {
                    lg = el[0];

                    // settings
                    const inlineGallery = lightGallery(lg, {
                        hash: true,
                        closable: true,
                        showMaximizeIcon: false,
                        slideDelay: 400,
                        plugins: [lgZoom, lgThumbnail, lgVideo],
                        download: false,
                        zoom: true,
                        counter: true,
                        thumbWidth: 60,
                        thumbHeight: "40px",
                        thumbMargin: 10,
                        mobileSettings: {showCloseIcon: true},
                    });

                    // events
                    lg.addEventListener('lgAfterOpen', ($) => {
                        // lazy load for woocommerce gallery
                        urls = [];
                        jQuery(el).find('li').each(function (index) {
                            urls.push(jQuery(this).attr('data-thumb'));
                        });
                        // add thumbnails to the gallery
                        jQuery('div.lg-show').find('div.lg-thumb-item').find('img').each(function (index) {
                            if (urls[index].includes('.fifu.app'))
                                jQuery(this).attr('data-src', urls[index]);
                            else if (urls[index].includes('.wp.com'))
                                jQuery(this).attr('src', `${urls[index]}?w=100&resize=100`);
                            else
                                jQuery(this).attr('src', urls[index]);
                        });
                    });

                    lg.addEventListener('lgAfterAppendSlide', () => {
                        // onerror for slider gallery
                        if (fifuSliderVars.fifu_error_url) {
                            jQuery('div.lg').find('img').each(function (index) {
                                jQuery(this).attr('onerror', "this.src='" + fifuSliderVars.fifu_error_url + "'");
                            });
                        }
                    });
                }
            }, 1500);

            // thumbnail (click)
            jQuery('ul.lSPager li a img').on('click', function () {
                if (fifuSliderVars.fifu_lazy) {
                    src = jQuery(this).attr('src');
                    // for jetpack
                    if (src.includes('.wp.com'))
                        src = src.split('?')[0];
                    fifu_add_lazyload(jQuery('img[data-src^="' + src + '"]')[0]);
                }
            });

            // fix elementor
            jQuery("article.elementor-portfolio-item > a.elementor-post__thumbnail__link > div.elementor-post__thumbnail > div.fifu-slider").parent().parent().attr("class", "");
            jQuery("div.elementor-post__thumbnail > div.fifu-slider").parent().attr("class", "");

            // external counter
            if (fifuSliderVars.fifu_slider_counter)
                jQuery(el).closest('.fifu-slider').find('#counter-slider').text(el.getCurrentSlideCount() + ' / ' + el.getTotalSlideCount());

            // hide thumbnails gallery
            if (el.getTotalSlideCount() == 1)
                jQuery(el).closest('.fifu-slider').find('ul.lSPager.lSGallery').hide();


            if (fifuSliderVars.fifu_is_product) {
                // max-height (for images with large height but small width)
                jQuery('div.fifu-woo-gallery ul').each(function (index) {
                    jQuery(this).css('max-height', '550px');
                });
                jQuery('div.fifu-woo-gallery li').each(function (index) {
                    jQuery(this).css('max-height', '550px');
                    jQuery(this).css('text-align', 'center');

                });
                jQuery('div.fifu-woo-gallery img').each(function (index) {
                    jQuery(this).css('max-height', '550px');
                    jQuery(this).css('object-fit', 'contain');
                    jQuery(this).css('display', 'unset');
                    if (!fifuSliderVars.fifu_adaptive_height)
                        jQuery(this).css('vertical-align', 'middle');
                });
            }
        },
        onBeforeStart: function (el) {
        },
        onBeforeNextSlide: function (el) {
            if (fifuSliderVars.fifu_lazy) {
                jQuery(el).find('li.lslide.active').each(function (index) {
                    fifu_add_lazyload(jQuery(this).next().find('img'))
                });
            }
        },
        onBeforePrevSlide: function (el) {
            if (fifuSliderVars.fifu_lazy) {
                jQuery(el).find('li.lslide').each(function (index) {
                    if (jQuery(this).hasClass('active')) {
                        if (index == 0)
                            fifu_add_lazyload(jQuery(el).find('li.lslide').last().find('img'));
                        else
                            fifu_add_lazyload(jQuery(this).prev().find('img'));
                    }
                });
            }
        },
        onBeforeSlide: function (el) {
            // external counter
            if (fifuSliderVars.fifu_slider_counter)
                jQuery(el).closest('.fifu-slider').find('#counter-slider').text(el.getCurrentSlideCount() + ' / ' + el.getTotalSlideCount());
        },
    });
}
