<?php

define('FIFU_FLICKR_SIZES', serialize(array(75, 100, 150, 240, 320, 500, 640, 800, 1024)));
define('FIFU_FLICKR_CHAR_SIZES', serialize(array('s', 't', 'q', 'm', 'n', '-', 'z', 'c', 'b')));

function fifu_is_valid_flickr_size($size) {
    foreach (unserialize(FIFU_FLICKR_CHAR_SIZES) as $i)
        if ($size == $i)
            return true;
    return false;
}

function is_from_flickr($url) {
    if (fifu_is_off('fifu_flickr'))
        return false;

    if (strpos($url, "staticflickr.com") !== false)
        return strpos($url, "_h.jpg") === false && strpos($url, "k.jpg") === false;
    return false;
}

function fifu_resize_flickr_image($size, $url) {
    if (!fifu_is_valid_flickr_size($size))
        $size = fifu_flickr_size_auto($size, 0);

    if ($size == '-')
        $size = '';

    $pattern = '/((_[\w])+)*\.[\w]+$/';
    $extension = null;
    preg_match($pattern, $url, $aux);
    if ($aux)
        $extension = explode('.', $aux[0])[1];

    $replacement = $size . '.';

    if ($size)
        $replacement = '_' . $replacement;

    if ($extension)
        return preg_replace($pattern, $replacement, $url) . $extension;
    return preg_replace($pattern, $replacement, $url);
}

function fifu_flickr_size_auto($width, $height) {
    $longest = $width >= $height ? $width : $height;

    if ($width == $height) {
        if ($longest <= 75)
            return 's';
        if ($longest <= 150)
            return 'q';
    }
    if ($longest <= 100)
        return 't';
    if ($longest <= 240)
        return 'm';
    if ($longest <= 320)
        return 'n';
    if ($longest <= 500)
        return '-';
    if ($longest <= 640)
        return 'z';
    if ($longest <= 800)
        return 'c';
    return 'b';
}

function fifu_flickr_get_set($url) {
    $set = '';
    $count = 0;
    foreach (unserialize(FIFU_FLICKR_SIZES) as $i)
        $set .= (($count++ != 0) ? ', ' : '') . fifu_resize_flickr_image($i, $url) . ' ' . $i . 'w';
    return $set;
}

function fifu_check_flickr_thumb($url) {
    if (!is_from_flickr($url))
        return $url;
    return preg_replace('/([_][stqmnzc]){0,1}_d.jpg/', '_d.jpg', $url);
}

