<?php

function fifu_convert($url) {
    if (fifu_from_google_drive($url))
        return fifu_google_drive_url($url);

    if (fifu_from_instagram($url))
        return fifu_instagram_url($url);

    return $url;
}

//Google Drive

function fifu_from_google_drive($url) {
    return strpos($url, 'drive.google.com') !== false;
}

function fifu_google_drive_id($url) {
    preg_match("/[-\w]{25,}/", $url, $matches);
    return $matches[0];
}

function fifu_google_drive_url($url) {
    return 'https://drive.google.com/uc?id=' . fifu_google_drive_id($url);
}

function fifu_is_google_drive_file($url) {
    return strpos($url, 'drive.google.com/file') !== false;
}

function fifu_get_final_google_drive_url($url) {
    $headers = get_headers($url, 1);
    return $headers['Location'];
}

//Instagram

function fifu_from_instagram($url) {
    return preg_match("/[^a-z]instagram.com/", $url);
}

function fifu_instagram_id($url) {
    preg_match("/[-\w]{11,}/", $url, $matches);
    return $matches[0];
}

function fifu_instagram_url($url) {
    return 'https://www.instagram.com/p/' . fifu_instagram_id($url) . '/media/?size=l';
}

function fifu_is_old_instagram_url($url) {
    return strpos($url, 'https://www.instagram.com/p/') !== false;
}

function fifu_is_new_instagram_url($url) {
    return strpos($url, 'https://scontent.cdninstagram.com/v/') !== false;
}

function fifu_instagram_new_to_old($url) {
    $aux = explode('&id=', $url)[1];
    $id = explode('&', $aux)[0];
    return 'https://www.instagram.com/p/' . $id . '/media/?size=l';
}

