<?php

function fifu_proxy_get_list() {
    $private = get_option('fifu_upload_private_proxy');
    if ($private) {
        $list = array();
        preg_match_all("/([0-9]{1,3}[.]){3}[0-9]{1,3}[:][0-9]{1,5}/", $private, $matches);
        foreach ($matches[0] as $proxy) {
            $proxy = explode(':', $proxy);
            array_push($list, array($proxy[0], $proxy[1]));
        }
        return $list;
    }

    $list = get_transient('fifu_proxy_list');
    if ($list)
        return $list;

    $html = fifu_get_html_code('https://free-proxy-list.net/');
    if (!$html)
        return null;

    $list = fifu_proxy_scrape($html);
    if ($list)
        set_transient('fifu_proxy_list', $list, 1800);

    return $list;
}

function fifu_proxy_scrape($html) {
    $proxies = array();
    $internalErrors = libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $trs = $dom->getElementsByTagname('tr');
    foreach ($trs as $tr) {
        $td = $tr->childNodes[0];
        preg_match('/([0-9]{1,3}[.]){3}[0-9]{1,3}/', $td->nodeValue, $tag);
        if (!$tag)
            continue;
        $ip = $tr->childNodes[0]->nodeValue;
        $port = $tr->childNodes[1]->nodeValue;
        array_push($proxies, array($ip, $port));
    }
    libxml_use_internal_errors($internalErrors);
    return $proxies;
}

function fifu_proxy_get_random($proxies) {
    if ($proxies) {
        $index = array_rand($proxies, 1);
        return $proxies[$index];
    }
    return null;
}

function fifu_proxy_download_url($url, $ip, $port, $user, $password) {
    $crl = curl_init();
    curl_setopt($crl, CURLOPT_PROXY, "{$ip}:{$port}");
    curl_setopt($crl, CURLOPT_URL, $url);
    curl_setopt($crl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($crl, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($crl, CURLOPT_HTTPPROXYTUNNEL, true);
    curl_setopt($crl, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($crl, CURLOPT_VERBOSE, true);

    if ($user)
        curl_setopt($crl, CURLOPT_PROXYUSERPWD, "{$user}:{$password}");

    $ret = curl_exec($crl);

    $content_type = curl_getinfo($crl, CURLINFO_CONTENT_TYPE);
    $verbose = curl_getinfo($crl);

    curl_close($crl);

    if ($content_type) {
        if (strpos($content_type, 'image') !== false)
            return $ret;
        return 'invalid-type';
    }

    return null;
}

function fifu_proxy_get_cache() {
    $cache = get_option('fifu_cache_proxy');
    return $cache ? unserialize($cache) : null;
}

function fifu_proxy_download_image($url) {
    $host = fifu_get_host($url);
    $cache_proxy = fifu_proxy_get_cache();
    $content = null;
    if ($cache_proxy) {
        $i = 0;
        foreach ($cache_proxy as $proxy) {
            if (isset($proxy[$host])) {
                $content = fifu_proxy_download_url($url, $proxy[$host][0], $proxy[$host][1], null, null);
                if (!$content)
                    unset($cache_proxy[$i]);
                else
                    break;
            }
            $i++;
        }
    } else {
        $cache_proxy = array();
    }
    if (!$content) {
        $proxies = fifu_proxy_get_list();
        foreach ($proxies as $proxy) {
            $content = fifu_proxy_download_url($url, $proxy[0], $proxy[1], null, null);
            if ($content == 'invalid-type')
                break;
            if ($content) {
                $arr[$host] = $proxy;
                array_push($cache_proxy, $arr);
                update_option('fifu_cache_proxy', serialize($cache_proxy), 'no');
                break;
            }
        }
    }
    if ($content) {
        $tmp = get_temp_dir() . date("Ymd-His") . '.jpg';
        file_put_contents($tmp, $content);
        return $tmp;
    }
    return null;
}

