function isYoutubeUrl($url) {
    return $url.includes("youtu");
}

function isVimeoUrl($url) {
    return $url.includes("vimeo.com");
}

function isCloudinaryVideoUrl($url) {
    return $url.includes("cloudinary.com") && $url.includes("/video/");
}

function isTumblrVideoUrl($url) {
    return $url.includes("tumblr.com");
}

function isLocalVideoUrl($url) {
    return $url.includes("/wp-content/uploads/") && $url.includes("mp4");
}

function isImgurVideoUrl($url) {
    return $url.includes("imgur.com") && $url.includes("mp4");
}

function isPublitioVideoUrl($url) {
    return $url.includes("publit.io") && $url.includes("mp4");
}

function isGagVideoUrl($url) {
    return $url.includes("9cache.com");
}

function isWpcomVideoUrl($url) {
    return $url.includes("videos.files.wordpress.com");
}

function isJwplayerVideoUrl($url) {
    return $url.includes("jwplayer.com");
}

function isSproutVideoUrl($url) {
    return $url.includes("vids.io");
}

function idYoutube($url) {
    var $regex = /^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user|shorts)\/))([^\?&\"'>]+)/;
    return $res = $url.match($regex);
}

function idVimeo($url) {
    var $regex = /^(http\:\/\/|https\:\/\/)?(www\.)?(vimeo\.com\/)([0-9]+).*$/;
    return $res = $url.match($regex);
}

function idJwplayer($url) {
    return $url.split('/')[4].split('.')[0];
}

function srcYoutube($url) {
    return "https://www.youtube.com/embed/" + idYoutube($url)[1];
}

function srcVimeo($url) {
    return "https://player.vimeo.com/video/" + idVimeo($url)[4];
}

function srcCloudinary($url) {
    return $url;
}

function srcTumblr($url) {
    return $url;
}

function srcLocal($url) {
    return $url;
}

function srcImgur($url) {
    return $url;
}

function srcPublitio($url) {
    return $url;
}

function srcGag($url) {
    return $url;
}

function srcWpcom($url) {
    return $url;
}

function srcJwplayer($url) {
    return "https://content.jwplatform.com/players/" + idJwplayer($url) + ".html";
}

function srcSprout($url) {
    return fifu_video_src($url);
}

function srcVideo($url) {
    if (isYoutubeUrl($url))
        return srcYoutube($url);
    if (isVimeoUrl($url))
        return srcVimeo($url);
    if (isCloudinaryVideoUrl($url))
        return srcCloudinary($url);
    if (isTumblrVideoUrl($url))
        return srcTumblr($url);
    if (isLocalVideoUrl($url))
        return srcLocal($url);
    if (isImgurVideoUrl($url))
        return srcImgur($url);
    if (isPublitioVideoUrl($url))
        return srcPublitio($url);
    if (isGagVideoUrl($url))
        return srcGag($url);
    if (isWpcomVideoUrl($url))
        return srcWpcom($url);
    if (isJwplayerVideoUrl($url))
        return srcJwplayer($url);
    if (isSproutVideoUrl($url))
        return srcSprout($url);
    return null;
}

function fifu_video_image_thumbnail(url, vars) {
    var response;

    jQuery.ajax({
        method: "POST",
        url: vars.restUrl + 'fifu-premium/v2/video_image_thumbnail/',
        async: false,
        data: {
            "url": url,
        },
        beforeSend: function (xhr) {
            xhr.setRequestHeader('X-WP-Nonce', vars.nonce);
        },
        success: function (data) {
            response = data;
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.log(jqXHR);
            console.log(textStatus);
            console.log(errorThrown);
        },
        complete: function (data) {
        },
    });

    return decodeURI(response);
}
