<?php

function fifu_find_featured_image($url, $find_video) {
    $html = fifu_get_html_code($url);
    if (!$html)
        return;

    if ($find_video) {
        $video_src = fifu_get_video($html, $url);
        if ($video_src)
            return $video_src;
    }

    $image_url = fifu_get_og_image($html);
    if ($image_url)
        return $image_url;

    return fifu_get_largest_img($html, $url);
}

function fifu_get_html_code($url) {
    $context = stream_context_create(
            array(
                "http" => array(
                    "header" => "User-Agent: Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36"
                )
            )
    );
    try {
        $html = file_get_contents($url, false, $context);
        return $html;
    } catch (Exception $e) {
        return null;
    }
}

function fifu_get_og_image($html) {
    libxml_use_internal_errors(true);
    $doc = new DomDocument();
    $doc->loadHTML($html);
    $xpath = new DOMXPath($doc);
    $query = '//*/meta[starts-with(@property, \'og:\')]';
    $metas = $xpath->query($query);
    $rmetas = array();
    foreach ($metas as $meta) {
        $property = $meta->getAttribute('property');
        $content = $meta->getAttribute('content');
        $rmetas[$property] = $content;
    }
    if ($rmetas && isset($rmetas['og:image']))
        return $rmetas['og:image'];
    return null;
}

function fifu_get_largest_img($html, $url) {
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $imgs = $dom->getElementsByTagname('img');
    $largest = "";
    $largest_area = 0;
    foreach ($imgs as $img) {
        $img_url = $img->getAttribute("src");
        if (empty($img_url)) {
            continue;
        }
        if (substr($img_url, 0, 2) === "//") {
            $img_url = "http:" . $img_url;
        } else if (substr($img_url, 0, 1) === "/") {
            $img_url = $url . $img_url;
        }
        $size = getimagesize($img_url);
        if ($size) {
            $width = $size[0];
            $height = $size[1];
            if ($width * $height > $largest_area) {
                $largest = $img_url;
                $largest_area = $width * $height;
            }
        }
    }
    return $largest;
}

function fifu_get_video($html, $url) {
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $iframes = $dom->getElementsByTagname('iframe');
    foreach ($iframes as $iframe) {
        $src = $iframe->getAttribute("src");
        if (empty($src)) {
            continue;
        }
        if (fifu_is_video($src))
            return $src;
    }
    return null;
}

function fifu_find_amazon_images($url) {
    libxml_use_internal_errors(true);

    $html = fifu_get_html_code($url);

    sleep(6);

    if (!$html)
        return;

    $arr_urls = array();

    // get thumbnails urls
    // $dom = new DOMDocument();
    // $dom->loadHTML($html);
    // $imgs = $dom->getElementById('altImages')->getElementsByTagname('img');
    // foreach ($imgs as $img) {
    //     $img_url = $img->getAttribute("src");
    //     if (strpos($img_url, 'media-amazon.com') !== false && strpos($img_url, 'play-icon') === false)
    //         array_push($arr_urls, $img_url);
    // }
    // get large images urls
    preg_match_all('/\[\{\"hiRes\".*\}\]/', $html, $json);
    if ($json) {
        $images = json_decode($json[0][0]);
        foreach ($images as $img)
            array_push($arr_urls, $img->hiRes);
    }

    if (!$arr_urls)
        return;

    return implode('|', $arr_urls);
}

