<?php

add_action('admin_init', 'fifu_column');
add_filter('admin_head', 'fifu_admin_add_css_js');

function fifu_column() {
    add_filter('manage_posts_columns', 'fifu_column_head');
    add_filter('manage_pages_columns', 'fifu_column_head');
    add_filter('manage_edit-product_cat_columns', 'fifu_column_head');
    fifu_column_custom_post_type();
    add_action('manage_posts_custom_column', 'fifu_column_content', 10, 2);
    add_action('manage_pages_custom_column', 'fifu_column_content', 10, 2);
    add_action('manage_product_cat_custom_column', 'fifu_ctgr_column_content', 10, 3);
}

function fifu_admin_add_css_js() {
    // buddyboss app
    if (isset($_REQUEST['page']) && strpos($_REQUEST['page'], 'bbapp') !== false)
        return;

    wp_enqueue_style('fifu-shortcode-css', plugins_url('/html/css/shortcode.css', __FILE__), array(), fifu_version_number());
    wp_enqueue_style('fancy-box-css', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.css');
    wp_enqueue_script('fancy-box-js', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js');
    wp_enqueue_style('fifu-column-css', plugins_url('/html/css/column.css', __FILE__), array(), fifu_version_number());
    wp_enqueue_script('fifu-video-util-js', plugins_url('/html/js/video-util.js', __FILE__), array('jquery'), fifu_version_number());
    wp_register_style('fifu-unsplash-css', plugins_url('/html/css/unsplash.css', __FILE__), array(), fifu_version_number());
    wp_enqueue_style('fifu-unsplash-css');
    wp_enqueue_script('fifu-unsplash-js', plugins_url('/html/js/unsplash.js', __FILE__), array('jquery'), fifu_version_number());
    wp_enqueue_script('fifu-column-js', plugins_url('/html/js/column.js', __FILE__), array('jquery'), fifu_version_number());

    $fifu = fifu_get_strings_quick_edit();
    $unsplash_size = get_option('fifu_unsplash_size');

    wp_localize_script('fifu-column-js', 'fifuColumnVars', [
        'restUrl' => esc_url_raw(rest_url()),
        'homeUrl' => esc_url_raw(home_url()),
        'nonce' => wp_create_nonce('wp_rest'),
        'labelImage' => $fifu['title']['image'](),
        'labelVideo' => $fifu['title']['video'](),
        'labelSearch' => $fifu['title']['search'](),
        'tipImage' => $fifu['tip']['image'](),
        'tipVideo' => $fifu['tip']['video'](),
        'tipSearch' => $fifu['tip']['search'](),
        'urlImage' => $fifu['url']['image'](),
        'urlVideo' => $fifu['url']['video'](),
        'keywords' => $fifu['image']['keywords'](),
        'unsplash_size' => $unsplash_size ? $unsplash_size : 'featured',
    ]);
}

function fifu_column_head($default) {
    $default['featured_image'] = '<span class="dashicons dashicons-camera" style="font-size:20px" title="Edit fast and saves in less than 1 second"></span> Quick edit';
    return $default;
}

function fifu_ctgr_column_content($internal_image, $column, $term_id) {
    if ($column == 'featured_image') {
        $border = '';
        $height = get_option('fifu_column_height');
        $width = $height * 1.5;

        $video_url = null;
        $video_src = null;
        $is_ctgr = true;
        $post_id = $term_id;
        $image_url = null;

        $url = get_term_meta($term_id, 'fifu_video_url', true);
        if ($url == '') {
            $image_url = get_term_meta($term_id, 'fifu_image_url', true);
            if ($image_url == '') {
                $thumb_id = get_term_meta($term_id, 'thumbnail_id', true);
                $image_url = wp_get_attachment_url($thumb_id);
                $border = 'border-color: #ca4a1f !important; border: 2px; border-style: dashed;';
            }
            $url = fifu_is_on('fifu_photon') ? fifu_jetpack_photon_url($image_url, fifu_get_photon_args($width, $height)) : $image_url;
            include 'html/column.html';
        } else {
            $video_url = $url;
            $video_src = fifu_video_src($video_url);
            $image_url = fifu_video_img_small($url);
            $url = fifu_is_on('fifu_photon') ? fifu_jetpack_photon_url($image_url, fifu_get_photon_args($width, $height)) : $image_url;
            include 'html/column.html';
        }
    } else
        echo $internal_image;
}

function fifu_column_content($column, $post_id) {
    if ($column == 'featured_image') {
        $border = '';
        $height = get_option('fifu_column_height');
        $width = $height * 1.5;

        $video_url = null;
        $video_src = null;
        $is_ctgr = false;
        $image_url = null;

        $url = get_post_meta($post_id, 'fifu_shortcode', true);
        if ($url == '') {
            $url = get_post_meta($post_id, 'fifu_video_url', true);
            if ($url == '') {
                $image_url = fifu_main_image_url($post_id);
                if ($image_url == '') {
                    $image_url = wp_get_attachment_url(get_post_thumbnail_id());
                    $border = 'border-color: #ca4a1f !important; border: 2px; border-style: dashed;';
                }
                $url = fifu_is_on('fifu_photon') ? fifu_jetpack_photon_url($image_url, fifu_get_photon_args($width, $height)) : $image_url;
                include 'html/column.html';
            } else {
                $video_url = $url;
                $video_src = fifu_video_src($video_url);
                $image_url = fifu_video_img_small($url);
                $url = fifu_is_on('fifu_photon') ? fifu_jetpack_photon_url($image_url, fifu_get_photon_args($width, $height)) : $image_url;
                include 'html/column.html';
            }
        } else {
            echo sprintf('<div style="height:%spx; width:%spx; --aspect-ratio:3/2">%s</div>', $height, $width, do_shortcode($url));
        }
    }
}

function fifu_column_custom_post_type() {
    foreach (fifu_get_post_types() as $post_type)
        add_filter('manage_edit-' . $post_type . '_columns', 'fifu_column_head');
}

