<?php

function fifu_query_vars($vars) {
    $vars[] = 'fifu_att_id';
    $vars[] = 'fifu_post_slug';
    return $vars;
}

add_filter('query_vars', 'fifu_query_vars');

function fifu_rewrite_rule() {
    add_rewrite_rule('^fifu/([^/]*)/([^/]*)/?$', 'index.php?fifu_att_id=$matches[1]&fifu_post_slug=$matches[2]', 'top');
    flush_rewrite_rules();
}

add_action('init', 'fifu_rewrite_rule');

function fifu_template_redirect() {
    $att_id = get_query_var('fifu_att_id');

    if ($att_id) {
        // Retrieve the post by ID
        $post = get_post($att_id);

        // Check if the post exists and redirect to its guid if so
        if ($post) {
            $att_url = wp_get_attachment_url($att_id);

            // Check for specific domain in request to apply new logic
            if (isset($_SERVER['HTTP_HOST']) && preg_match('/^i\d+\.wp\.com$/', $_SERVER['HTTP_HOST'])) {
                // Calculate the 'i' value based on the $att_url for the new logic
                $number = (hexdec(substr(md5($att_url), 0, 1)) % 4);

                // Append query parameters if present
                $query_params = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';

                // Construct the new redirect URL
                $redirect_url = "https://i{$number}.wp.com" . parse_url($att_url, PHP_URL_PATH) . $query_params;

                wp_redirect($redirect_url);
            } else {
                // Original logic: Perform a redirect to the guid URL
                $redirect_url = $att_url;

                if (FIFU_DEEP_CLOAK) {
                    // Instead of redirecting, fetch and return the image content
                    $imageContent = file_get_contents($redirect_url);

                    if ($imageContent !== false) {
                        // Determine the content type of the image
                        $finfo = new finfo(FILEINFO_MIME_TYPE);
                        $contentType = $finfo->buffer($imageContent);

                        // Set the appropriate header for the content type
                        header("Content-Type: $contentType");

                        // Output the image content
                        echo $imageContent;
                    }
                } else {
                    wp_redirect($redirect_url);
                }
            }
            exit;
        } else {
            // Redirect to the home page if the post doesn't exist
            wp_redirect(home_url());
            exit;
        }
    }
}

add_action('template_redirect', 'fifu_template_redirect');

