var isDraggingImage = false;

// sizes
function fifu_woo_get_sizes(i) {
    url = jQuery('input[id^=fifu_input_url_' + i + ']').val();
    if (!url || !url.startsWith("http"))
        return;
    fifu_woo_get_image(url, i);
}

function fifu_woo_get_image(url, i) {
    var image = new Image();
    jQuery(image).attr('onload', 'fifu_woo_store_sizes(this,' + i + ');');
    jQuery(image).attr('src', url);
}

function fifu_woo_store_sizes($, i) {
    jQuery("#fifu_input_width_" + i).val($.naturalWidth);
    jQuery("#fifu_input_height_" + i).val($.naturalHeight);
}

var maxImage = 0;

// run once
jQuery(document).ready(function () {
    fifu_box_init();
});

function fifu_box_init() {
    let text = jQuery("div#wooGalleryMetaBox").find('h2').text();
    jQuery("div#wooGalleryMetaBox").find('h2.hndle').text('');
    jQuery("div#wooGalleryMetaBox").find('h2').append('<h4 style="left:-10px;position:relative;font-size:13px;font-weight:normal"><span class="dashicons dashicons-format-gallery"></span> ' + text + '</h4>');
    jQuery("div#wooGalleryMetaBox").find('button.handle-order-higher').remove();
    jQuery("div#wooGalleryMetaBox").find('button.handle-order-lower').remove();

    const MIN = 11;

    // quick edit
    if (currentLightbox)
        fifu_image_gallery_info(currentLightbox);

    numberUrls = fifuBoxImageVars.urls ? fifuBoxImageVars.urls.length : 0;
    numberInputs = numberUrls <= MIN ? MIN : numberUrls;

    // add placeholders
    for (i = 0; i < numberInputs; i++) {
        jQuery('#gridDemoImage').append(`<div id="fifu-image-${i}" class="grid-square image"></div>`);
        maxImage = i;
    }

    // add plus button
    jQuery('#gridDemoImage').append(`<div id="fifu-add-image" class="grid-square image-add"></div>`);

    // add images
    for (i = 0; i < numberInputs; i++) {
        url = fifuBoxImageVars.urls[i];
        alt = fifuBoxImageVars.alts[i];

        url = url !== undefined ? url : "";
        alt = alt !== undefined ? alt : "";

        if (url) {
            selector = `#fifu-image-${i}`;

            let adjustedUrl = fifu_cdn_adjust(url);

            jQuery(selector).css('background', `url("${adjustedUrl}") center center / cover no-repeat`);
            jQuery(selector).css('opacity', '1');
        }

        // add input hiddens
        jQuery('#inputHiddenImages').append(`
            <input type="hidden" id="fifu_input_width_${i}" name="fifu_input_width_${i}" value="" >
            <input type="hidden" id="fifu_input_height_${i}" name="fifu_input_height_${i}" value="" >
            <input type="hidden" id="fifu_input_url_${i}" name="fifu_input_url_${i}" value="${url}">
            <input type="hidden" id="fifu_input_alt_${i}" name="fifu_input_alt_${i}" value="${alt}">
        `);

        // get sizes
        if (url)
            fifu_woo_get_sizes(i);
    }

    // start lists
    updateImageList();

    /////////////////////////////////////////////////

    // init sortable
    if (jQuery('#gridDemoImage').length) {
        jQuery('#gridDemoImage').sortable({
            start: function (event, ui) {
                isDraggingImage = false; // Reset the flag
            },
            stop: function (event, ui) {
                isDraggingImage = true; // Set the flag to indicate dragging occurred
            }
        });
    }

    // prepare fancy boxes 
    addFancyBoxImage();

    // add new image: onclick event
    jQuery(document).on('click', '#fifu-add-image', function (evt) {
        if (isDraggingImage) {
            isDraggingImage = false;
            return;
        }

        evt.stopImmediatePropagation();
        maxImage++;
        jQuery('#gridDemoImage').append(`<div id="fifu-image-${maxImage}" class="grid-square image"></div>`);

        jQuery('#inputHiddenImages').append(`
            <input type="hidden" id="fifu_input_width_${maxImage}" name="fifu_input_width_${maxImage}" value="" >
            <input type="hidden" id="fifu_input_height_${maxImage}" name="fifu_input_height_${maxImage}" value="" >
            <input type="hidden" id="fifu_input_url_${maxImage}" name="fifu_input_url_${maxImage}" value="">
            <input type="hidden" id="fifu_input_alt_${maxImage}" name="fifu_input_alt_${maxImage}" value="">
        `);
        addFancyBoxImage();
    });

    jQuery('div.grid-square').on('mouseout', function (evt) {
        evt.stopImmediatePropagation();
        updateImageList();
    });
}

// prepare fancy boxes
function addFancyBoxImage() {
    jQuery(document).on('click', 'div[id^="fifu-image-"]', function (evt) {
        if (isDraggingImage) {
            isDraggingImage = false;
            return;
        }

        evt.stopImmediatePropagation();
        divId = jQuery(this).attr('id');
        index = divId.split('-')[2];

        url = jQuery(`#fifu_input_url_${index}`).val();
        alt = jQuery(`#fifu_input_alt_${index}`).val();
        url = url ? url : "";
        alt = alt ? alt : "";

        let adjustedUrl = fifu_cdn_adjust(url);

        imgTag = url ? `<img id="img-fifu-image" src="${adjustedUrl}" style="width:275px;margin-top:5px;margin-left:1px"><br>` : '<br>';

        jQuery.fancybox.open(`
            <input id="input-${divId}" placeholder="${fifuBoxImageVars.text_url}" value="${url}" style="width:275px;padding:5px;height:36px"><br>
            <span id="span-img-fifu-image">
            ${imgTag}
            </span>
            <input id="alt-input-image-${divId}" placeholder="${fifuBoxImageVars.text_alt}" value="${alt}" style="width:275px;padding:5px;height:36px"><br>
            <button id="button-fifu-image" type="button" style="width:275px;padding:5px;height:36px">${fifuBoxImageVars.text_ok}</button>
        `);
        jQuery(`#input-${divId}`).focus();
        jQuery(`#input-${divId}`).select();
    });
}

// change URL
jQuery(document).on('keyup', 'input[id^="input-fifu-image"]', function (evt) {
    evt.stopImmediatePropagation();

    inputId = jQuery(this).attr('id');
    divId = inputId.replace('input-', '');
    index = divId.split('-')[2];

    url = jQuery(`#${inputId}`).val();
    url = !url.startsWith('http') ? '' : fifu_convert(url);

    jQuery(`#fifu_input_url_${index}`).val(url);

    jQuery(`#span-img-fifu-image`).empty();

    let adjustedUrl = fifu_cdn_adjust(url);
    jQuery(`#span-img-fifu-image`).append(`<img id="img-fifu-image" src="${adjustedUrl}" style="width:275px;margin-top:5px;margin-left:1px"><br>`);

    if (!url)
        jQuery(`#${divId}`).attr('style', '');
    else {
        let adjustedUrl = fifu_cdn_adjust(url);
        jQuery(`#${divId}`).css('background', `url("${adjustedUrl}") center center / cover no-repeat`);
        jQuery(`#${divId}`).css('opacity', '1');
        fifu_woo_get_sizes(index);
    }

    updateImageList();

    if (evt.which === 13 || evt.which === 27)
        jQuery.fancybox.close();
});

// change ALT
jQuery(document).on('keyup', 'input[id^="alt-input-image-fifu"]', function (evt) {
    evt.stopImmediatePropagation();
    inputId = jQuery(this).attr('id');
    divId = inputId.replace('alt-input-image-', '');
    index = divId.split('-')[2];

    alt = jQuery(`#${inputId}`).val();
    jQuery(`#fifu_input_alt_${index}`).val(alt);

    updateImageList();

    if (evt.which === 13 || evt.which === 27)
        jQuery.fancybox.close();
});

// OK button
jQuery(document).on('click', '#button-fifu-image', function (evt) {
    evt.stopImmediatePropagation();
    updateImageList();
    jQuery.fancybox.close();
});

// update the list of urls
function updateImageList() {
    var imageListIds = "";
    i = 0;
    jQuery('div[id^="fifu-image"]').each(function (index) {
        divId = jQuery(this).attr('id');
        index = divId.split('-')[2];
        url = jQuery(`#fifu_input_url_${index}`).val();
        if (url && url.startsWith('http')) {
            imageListIds += (i == 0) ? '' : '|';
            imageListIds += index;
            i++;
        }
    });
    jQuery('#inputHiddenImageListIds').val(imageListIds);
    jQuery('#inputHiddenImageLength').val(jQuery('div[id^="fifu-image"]').length);
}

// dokan

var fifuBoxInitialized = false;
var observer = new MutationObserver(function (mutations) {
    mutations.forEach(function (mutation) {
        hidden = jQuery(mutation.target).attr('aria-hidden') == 'true';
        if (hidden) {
            fifuBoxInitialized = false;
        } else {
            if (!fifuBoxInitialized) {
                fifu_box_init();
                fifuBoxInitialized = true;
            }
        }
    });
});

var target = document.getElementById('dokan-add-product-popup');
if (target)
    observer.observe(target, {attributes: true, attributeFilter: ['aria-hidden']});


// quick edit

function fifu_image_gallery_info(post_id) {
    fifuBoxImageVars.urls = fifuQuickEditVars.posts[post_id]['fifu_image_urls'];
    fifuBoxImageVars.alts = fifuQuickEditVars.posts[post_id]['fifu_image_alts'];
}
