var isDraggingSlider = false;

// add meta box icon
jQuery(document).ready(function () {
    let text = jQuery("div#wooSliderImageUrlMetaBox").find('h2').text();
    jQuery("div#wooSliderImageUrlMetaBox").find('h2.hndle').text('');
    jQuery("div#wooSliderImageUrlMetaBox").find('h2').append('<h4 style="left:-10px;position:relative;font-size:13px;font-weight:normal"><span class="dashicons dashicons-images-alt2"></span> ' + text + '</h4>');
    jQuery("div#wooSliderImageUrlMetaBox").find('button.handle-order-higher').remove();
    jQuery("div#wooSliderImageUrlMetaBox").find('button.handle-order-lower').remove();

    text = jQuery("div#sliderImageUrlMetaBox").find('h2').text();
    jQuery("div#sliderImageUrlMetaBox").find('h2.hndle').text('');
    jQuery("div#sliderImageUrlMetaBox").find('h2').append('<h4 style="left:-10px;position:relative;font-size:13px;font-weight:normal"><span class="dashicons dashicons-images-alt2"></span> ' + text + '</h4>');
    jQuery("div#sliderImageUrlMetaBox").find('button.handle-order-higher').remove();
    jQuery("div#sliderImageUrlMetaBox").find('button.handle-order-lower').remove();

    if (fifuSliderVars.is_product)
        jQuery('#gridDemoSlider').attr('style', 'position:relative;left:13px');
});

// sizes
function fifu_slider_get_sizes(i) {
    slider_url = jQuery('input[id^=fifu_slider_input_url_' + i + ']').val();
    fifu_slider_get_image(slider_url, i);
}

function fifu_slider_get_image(url, i) {
    var image = new Image();
    jQuery(image).attr('onload', 'fifu_slider_store_sizes(this,' + i + ');');
    jQuery(image).attr('src', url);
}

function fifu_slider_store_sizes($, i) {
    jQuery("#fifu_slider_input_width_" + i).val($.naturalWidth);
    jQuery("#fifu_slider_input_height_" + i).val($.naturalHeight);
}

// video sizes

function fifu_slider_video_get_sizes(i) {
    video_url = jQuery('input[id^=fifu_slider_input_url_' + i + ']').val();
    if (!video_url || (!video_url.startsWith("http") && !video_url.startsWith("//")))
        return;
    image_url = fifu_video_image_thumbnail(video_url, fifuSliderVars);
    fifu_slider_video_get_image(image_url, i);
}

function fifu_slider_video_get_image(url, i) {
    var image = new Image();
    jQuery(image).attr('onload', 'fifu_slider_video_store_sizes(this,' + i + ');');
    jQuery(image).attr('src', url);
}

function fifu_slider_video_store_sizes($, i) {
    let src = $.src;
    jQuery("#fifu_slider_input_width_" + i).val($.naturalWidth);
    jQuery("#fifu_slider_input_height_" + i).val($.naturalHeight);
    if ($.naturalWidth == 120 && $.naturalHeight == 90)
        jQuery("#fifu_slider_input_image_src_" + i).val(src.replace('maxresdefault', 'mqdefault'));
    else
        jQuery("#fifu_slider_input_image_src_" + i).val(src);

    // load thumbnail gallery
    if (!src) {
        src = jQuery("#fifu_slider_input_image_src_" + i).val();
    }
    selector = `#fifu-slider-${i}`;
    jQuery(selector).css('background', `url("${src}") center center / cover no-repeat`);
    jQuery(selector).css('opacity', '1');
    jQuery(`#fifu_slider_input_url_${i}`).val(function (index, currentContent) {
        currentContent = currentContent.split('#http')[0];
        return `${currentContent}#${src}`;
    });
}

var maxSlider = 0;

// run once
jQuery(document).ready(function () {
    fifu_slider_box_init();
});

function fifu_slider_box_init() {
    const MIN = 11;

    // quick edit
    if (currentLightbox)
        fifu_slider_info(currentLightbox);

    numberUrls = fifuSliderVars.urls ? fifuSliderVars.urls.length : 0;
    numberInputs = numberUrls <= MIN ? MIN : numberUrls;

    // add placeholders
    for (i = 0; i < numberInputs; i++) {
        jQuery('#gridDemoSlider').append(`<div id="fifu-slider-${i}" class="grid-square image"></div>`);
        maxSlider = i;
    }

    // add plus button
    jQuery('#gridDemoSlider').append(`<div id="fifu-add-slider" class="grid-square image-add"></div>`);

    // add images
    for (i = 0; i < numberInputs; i++) {
        url = fifuSliderVars.urls[i];
        alt = fifuSliderVars.alts[i];

        image_url = '';
        video_url = '';
        if (url !== undefined) {
            pos = url.indexOf('#http');
            if (pos !== -1) {
                image_url = url.substring(pos + 1);
                video_url = url.substring(0, pos);
            } else
                image_url = url;
        }

        alt = alt !== undefined ? alt : "";

        if (image_url) {
            selector = `#fifu-slider-${i}`;
            jQuery(selector).css('background', `url("${image_url}") center center / cover no-repeat`);
            jQuery(selector).css('opacity', '1');
        }

        // add input hiddens
        jQuery('#inputHiddenSliders').append(`
            <input type="hidden" id="fifu_slider_input_width_${i}" name="fifu_slider_input_width_${i}" value="" >
            <input type="hidden" id="fifu_slider_input_height_${i}" name="fifu_slider_input_height_${i}" value="" >
            <input type="hidden" id="fifu_slider_input_url_${i}" name="fifu_slider_input_url_${i}" value="${url}">
            <input type="hidden" id="fifu_slider_input_alt_${i}" name="fifu_slider_input_alt_${i}" value="${alt}">
        `);

        // get sizes
        if (url) {
            fifu_slider_get_sizes(i);
        }
    }

    // start lists
    updateSliderList();

    /////////////////////////////////////////////////

    // init sortable
    if (jQuery('#gridDemoSlider').length) {
        jQuery('#gridDemoSlider').sortable({
            start: function (event, ui) {
                isDraggingSlider = false; // Reset the flag
            },
            stop: function (event, ui) {
                isDraggingSlider = true; // Set the flag to indicate dragging occurred
            }
        });
    }

    // prepare fancy boxes 
    addFancyBoxSlider();

    // add new image: onclick event
    jQuery(document).on('click', '#fifu-add-slider', function (evt) {
        if (isDraggingSlider) {
            isDraggingSlider = false;
            return;
        }

        evt.stopImmediatePropagation();
        maxSlider++;
        jQuery('#gridDemoSlider').append(`<div id="fifu-slider-${maxSlider}" class="grid-square image"></div>`);

        jQuery('#inputHiddenSliders').append(`
            <input type="hidden" id="fifu_slider_input_width_${maxSlider}" name="fifu_slider_input_width_${maxSlider}" value="" >
            <input type="hidden" id="fifu_slider_input_height_${maxSlider}" name="fifu_slider_input_height_${maxSlider}" value="" >
            <input type="hidden" id="fifu_slider_input_url_${maxSlider}" name="fifu_slider_input_url_${maxSlider}" value="">
            <input type="hidden" id="fifu_slider_input_alt_${maxSlider}" name="fifu_slider_input_alt_${maxSlider}" value="">
        `);
        addFancyBoxSlider();
    });

    jQuery('div.grid-square').on('mouseout', function (evt) {
        evt.stopImmediatePropagation();
        updateSliderList();
    });
}

// prepare fancy boxes
function addFancyBoxSlider() {
    jQuery(document).on('click', 'div[id^="fifu-slider-"]', function (evt) {
        if (isDraggingSlider) {
            isDraggingSlider = false;
            return;
        }

        evt.stopImmediatePropagation();
        divId = jQuery(this).attr('id');
        index = divId.split('-')[2];

        url = jQuery(`#fifu_slider_input_url_${index}`).val();
        alt = jQuery(`#fifu_slider_input_alt_${index}`).val();
        url = url !== 'undefined' && url ? url : "";
        alt = url !== 'undefined' && alt ? alt : "";

        let imgTag = '';
        let iframeTag = '';
        let image_url = '';
        let video_url = '';
        if (url) {
            if (fifu_is_video(url)) {
                iframeTag = `<iframe id="iframe-fifu-slider" width="100%" src="${srcVideo(url)}" allowfullscreen frameborder="0" style="width:275px;margin-top:5px;margin-left:1px"></iframe><br>`;
                video_url = url;
            } else {
                imgTag = `<img id="img-fifu-slider" src="${url}" style="width:275px;margin-top:5px;margin-left:1px"><br>`;
                image_url = url;
            }
        }

        jQuery.fancybox.open(`
            <input id="input-${divId}" placeholder="${fifuSliderVars.text_image_url}" value="${image_url}" style="width:275px;padding:5px;height:36px"><br>
            <input id="input-video-${divId}" placeholder="${fifuSliderVars.text_video_url}" value="${video_url}" style="width:275px;padding:5px;height:36px"><br>
            <span id="span-img-fifu-slider">
            ${imgTag}
            </span>
            <span id="span-iframe-fifu-slider">
            ${iframeTag}
            </span>
            <input id="alt-input-${divId}" placeholder="${fifuSliderVars.text_alt}" value="${alt}" style="width:275px;padding:5px;height:36px"><br>
            <button id="button-fifu-slider" type="button" style="width:275px;padding:5px;height:36px">${fifuSliderVars.text_ok}</button>
        `);
        jQuery(`#input-${divId}`).focus();
        jQuery(`#input-${divId}`).select();
    });
}

// change URL
jQuery(document).on('keyup', 'input[id^="input-fifu-slider"]', function (evt) {
    evt.stopImmediatePropagation();

    inputId = jQuery(this).attr('id');
    divId = inputId.replace('input-', '');
    index = divId.split('-')[2];

    url = jQuery(`#${inputId}`).val();
    url = !url.startsWith('http') ? '' : fifu_convert(url);

    jQuery(`#fifu_slider_input_url_${index}`).val(url);

    jQuery(`#span-img-fifu-slider`).empty();
    jQuery(`#span-iframe-fifu-slider`).empty();

    jQuery(`#span-img-fifu-slider`).append(`<img id="img-fifu-slider" src="${url}" style="width:275px;margin-top:5px;margin-left:1px"><br>`);

    if (!url)
        jQuery(`#${divId}`).attr('style', '');
    else {
        jQuery(`#${divId}`).css('background', `url("${url}") center center / cover no-repeat`);
        jQuery(`#${divId}`).css('opacity', '1');
        fifu_slider_get_sizes(index);
    }

    updateSliderList();

    if (evt.which === 13 || evt.which === 27)
        jQuery.fancybox.close();
});

// change video URL
jQuery(document).on('keyup', 'input[id^="input-video-fifu-slider"]', function (evt) {
    evt.stopImmediatePropagation();

    inputId = jQuery(this).attr('id');
    divId = inputId.replace('input-video-', '');
    index = divId.split('-')[2];

    url = jQuery(`#${inputId}`).val();
    url = !url.startsWith('http') ? '' : fifu_convert_video(url);

    jQuery(`#fifu_slider_input_url_${index}`).val(url);

    jQuery(`#span-img-fifu-slider`).empty();
    jQuery(`#span-iframe-fifu-slider`).empty();

    if (!url)
        jQuery(`#${divId}`).attr('style', '');
    else {
        jQuery(`#span-iframe-fifu-slider`).append(`<iframe id="iframe-fifu-slider" width="100%" src="${srcVideo(url)}" allowfullscreen frameborder="0" style="width:275px;margin-top:5px;margin-left:1px"></iframe><br>`);
        fifu_slider_video_get_sizes(index);
    }

    updateSliderList();

    if (evt.which === 13 || evt.which === 27)
        jQuery.fancybox.close();
});

// change ALT
jQuery(document).on('keyup', 'input[id^="alt-input-fifu"]', function (evt) {
    evt.stopImmediatePropagation();
    inputId = jQuery(this).attr('id');
    divId = inputId.replace('alt-input-', '');
    index = divId.split('-')[2];

    alt = jQuery(`#${inputId}`).val();
    jQuery(`#fifu_slider_input_alt_${index}`).val(alt);

    updateSliderList();

    if (evt.which === 13 || evt.which === 27)
        jQuery.fancybox.close();
});

// OK button
jQuery(document).on('click', '#button-fifu-slider', function (evt) {
    evt.stopImmediatePropagation();
    updateSliderList();
    jQuery.fancybox.close();
});

// update the list of urls
function updateSliderList() {
    var sliderListIds = "";
    i = 0;
    jQuery('div[id^="fifu-slider"]').each(function (index) {
        divId = jQuery(this).attr('id');
        index = divId.split('-')[2];
        url = jQuery(`#fifu_slider_input_url_${index}`).val();
        if (url && url.startsWith('http')) {
            sliderListIds += (i == 0) ? '' : '|';
            sliderListIds += index;
            i++;
        }
    });
    jQuery('#inputHiddenSliderListIds').val(sliderListIds);
    jQuery('#inputHiddenSliderLength').val(jQuery('div[id^="fifu-slider"]').length);
}

// quick edit

function fifu_slider_info(post_id) {
    fifuSliderVars.urls = fifuQuickEditVars.posts[post_id]['fifu_slider_image_urls'];
    fifuSliderVars.alts = fifuQuickEditVars.posts[post_id]['fifu_slider_image_alts'];
}
