<?php

add_action('rest_api_init', function () {
    register_rest_route('fifu-premium/v2', '/cron-add/', array(
        'methods' => 'POST',
        'callback' => 'fifu_api_cron_add',
        'permission_callback' => 'fifu_get_private_data_permissions_check',
    ));
    register_rest_route('fifu-premium/v2', '/cron-delete/', array(
        'methods' => 'POST',
        'callback' => 'fifu_api_cron_delete',
        'permission_callback' => 'fifu_get_private_data_permissions_check',
    ));
    register_rest_route('fifu-premium/v2', '/cron-run/', array(
        'methods' => 'POST',
        'callback' => 'fifu_api_cron_run',
        'permission_callback' => function ($request) {
            $token = $request->get_header('X-FIFU-Authorization');
            return $token === get_option('fifu_ws_key_ddg');
        },
        'args' => array(
            'feature' => array(
                'required' => true,
                'validate_callback' => function ($param, $request, $key) {
                    return in_array($param, ['fifu_toggle_screenshot', 'fifu_toggle_tags', 'fifu_toggle_isbn', 'fifu_toggle_customfield', 'fifu_toggle_finder', 'fifu_toggle_auto_set', 'fifu_toggle_upload_job', 'fifu_toggle_cloud_upload_auto', 'fifu_toggle_cron_metadata']);
                }
            ),
        ),
    ));
});

function fifu_api_cron_add(WP_REST_Request $request) {
    $toggle = $request['toggle'];

    $data = array(
        'site' => get_home_url(),
        'route' => get_rest_url(),
        'plugin' => FIFU_CLIENT,
        'version' => fifu_version_number(),
        'key' => fifu_partial_key(),
        'feature' => $toggle,
    );

    $query_string = http_build_query($data);

    $url = "https://plugin.featuredimagefromurl.com/api/cron_add/?" . $query_string;

    $args = array(
        'headers' => array(
            'Content-Type' => 'application/json',
            'Authorization' => get_option('fifu_ws_key_ddg'),
        ),
        'timeout' => 60,
    );

    $response = wp_remote_get($url, $args);

    if (is_wp_error($response)) {
        $error_message = $response->get_error_message();
        fifu_plugin_log(['cron-add' => ['ERROR' => $error_message, 'toggle' => $toggle]]);
        return new WP_REST_Response('', 500);
    } else {
        $status_code = wp_remote_retrieve_response_code($response);
        fifu_plugin_log(['cron-add' => ['INFO' => $status_code, 'toggle' => $toggle]]);
    }

    return new WP_REST_Response('', $status_code);
}

function fifu_api_cron_delete(WP_REST_Request $request) {
    $toggle = $request['toggle'];

    $data = array(
        'site' => get_home_url(),
        'feature' => $toggle,
    );

    $query_string = http_build_query($data);

    $url = "https://plugin.featuredimagefromurl.com/api/cron_delete/?" . $query_string;

    $args = array(
        'headers' => array(
            'Content-Type' => 'application/json',
            'Authorization' => get_option('fifu_ws_key_ddg'),
        ),
        'timeout' => 60,
    );

    $response = wp_remote_get($url, $args);

    if (is_wp_error($response)) {
        $error_message = $response->get_error_message();
        fifu_plugin_log(['cron-delete' => ['ERROR' => $error_message, 'toggle' => $toggle]]);
        return new WP_REST_Response('', 500);
    } else {
        $status_code = wp_remote_retrieve_response_code($response);
        fifu_plugin_log(['cron-delete' => ['INFO' => $status_code, 'toggle' => $toggle]]);
    }

    return new WP_REST_Response('', $status_code);
}

function fifu_api_cron_run(WP_REST_Request $request) {
    $toggle = $request->get_param('feature');
    $option = str_replace('toggle_', '', $toggle);
    $id = str_replace('fifu_toggle_', '', $toggle);

    if (fifu_is_off($option))
        return new WP_REST_Response('', 200);

    $functionName = str_replace('toggle', 'cron', $toggle);
    $functionName($id);

    return new WP_REST_Response('', 200);
}

////////////////////////// RUN //////////////////////////

function fifu_cron_screenshot() {
    $result = fifu_db_get_posts_types_without_screenshot();
    foreach ($result as $res)
        fifu_dev_set_image($res->post_id, "https://screenshot.fifu.app/{$res->url}");
}

function fifu_cron_tags($id) {
    fifu_create_generic_hook($id);
}

function fifu_cron_isbn($id) {
    fifu_create_generic_hook($id);
}

function fifu_cron_customfield($id) {
    fifu_create_customfield_hook();
}

function fifu_cron_finder($id) {
    fifu_create_generic_hook($id);
}

function fifu_cron_auto_set($id) {
    fifu_create_generic_hook($id);
}

function fifu_cron_upload_job($id) {
    fifu_create_generic_hook('uploadpost');
    fifu_create_generic_hook('uploadterm');
}

function fifu_cron_cloud_upload_auto($id) {
    fifu_create_cloud_upload_auto_hook();
}

function fifu_cron_cron_metadata($id) {
    fifu_create_generic_hook('metadatapost');
    fifu_create_generic_hook('metadataterm');
}

////////////////////////// NOW //////////////////////////

function fifu_wp_after_insert_post($post_id, $post, $update) {
    if (fifu_is_on('fifu_screenshot'))
        fifu_cron_screenshot();
}

add_action('wp_after_insert_post', 'fifu_wp_after_insert_post', 10, 3);

